<?php

namespace UserWallet;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserWallet extends Eloquent {

	protected $table = 'user_wallets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('earned', 'redeemed');

	public function getUser()
	{
		return $this->hasOne('User', 'user_id');
	}

}