<?php

namespace Vehicle;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Vehicle extends Eloquent {

	protected $table = 'vehicles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'vehicle_no', 'colour', 'is_active');

	public function getDriver()
	{
		return $this->hasOne('Driver', 'driver_id');
	}

}