<?php

namespace Vehicle;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vehicle extends Model 
{

    protected $table = 'vehicles';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'vehicle_no', 'colour', 'is_active');

    public function getDriver()
    {
        return $this->hasOne('Driver', 'driver_id');
    }

}