<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiclesTable extends Migration {

	public function up()
	{
		Schema::create('vehicles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('driver_id');
			$table->string('name', 250);
			$table->string('vehicle_no', 150)->nullable();
			$table->string('colour', 150)->nullable();
			$table->enum('is_active', array('0', '1'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('vehicles');
	}
}