<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('plan_vendors', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plan_vendors', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('vendors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plan_voucher_codes', function(Blueprint $table) {
			$table->foreign('plan_vendor_id')->references('id')->on('plan_vendors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_plan_requests', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_plan', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_plan_log', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('vendors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->foreign('plan_vendor_id')->references('id')->on('plan_vendors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_feature_usage', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_feature_usage', function(Blueprint $table) {
			$table->foreign('feature_id')->references('id')->on('user_feature_availables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfer_plan', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('plan_vendors', function(Blueprint $table) {
			$table->dropForeign('plan_vendors_plan_id_foreign');
		});
		Schema::table('plan_vendors', function(Blueprint $table) {
			$table->dropForeign('plan_vendors_vendor_id_foreign');
		});
		Schema::table('plan_voucher_codes', function(Blueprint $table) {
			$table->dropForeign('plan_voucher_codes_plan_vendor_id_foreign');
		});
		Schema::table('user_plan_requests', function(Blueprint $table) {
			$table->dropForeign('user_plan_requests_plan_id_foreign');
		});
		Schema::table('user_plan', function(Blueprint $table) {
			$table->dropForeign('user_plan_plan_id_foreign');
		});
		Schema::table('user_plan_log', function(Blueprint $table) {
			$table->dropForeign('user_plan_log_plan_id_foreign');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->dropForeign('user_feature_availables_plan_id_foreign');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->dropForeign('user_feature_availables_vendor_id_foreign');
		});
		Schema::table('user_feature_availables', function(Blueprint $table) {
			$table->dropForeign('user_feature_availables_plan_vendor_id_foreign');
		});
		Schema::table('user_feature_usage', function(Blueprint $table) {
			$table->dropForeign('user_feature_usage_plan_id_foreign');
		});
		Schema::table('user_feature_usage', function(Blueprint $table) {
			$table->dropForeign('user_feature_usage_feature_id_foreign');
		});
		Schema::table('transfer_plan', function(Blueprint $table) {
			$table->dropForeign('transfer_plan_plan_id_foreign');
		});
	}
}