<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabCityTable extends Migration {

	public function up()
	{
		Schema::create('tabCity', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('status', 10)->default('Active');
			$table->text('description')->nullable();
			$table->string('owner');
			$table->integer('country_id')->unsigned();
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tabCity');
	}
}