<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabOfferTable extends Migration {

	public function up()
	{
		Schema::create('tabOffer', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('status', 10)->default('Active');
			$table->string('title');
			$table->string('type');
			$table->integer('sort_order');
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tabOffer');
	}
}