<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabEventTable extends Migration {

	public function up()
	{
		Schema::create('tabEvent', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('status', 10)->default('Active');
			$table->string('name');
			$table->integer('category_id')->unsigned();
			$table->text('description');
			$table->date('event_date');
			$table->time('event_time');
			$table->text('address');
			$table->integer('city_id')->unsigned();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tabEvent');
	}
}