<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabBrandTable extends Migration {

	public function up()
	{
		Schema::create('tabBrand', function(Blueprint $table) {
			$table->increments('id');
			$table->string('logo')->nullable();
			$table->string('avatar')->nullable();
			$table->string('name');
			$table->string('status', 10)->default('Active');
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tabBrand');
	}
}