<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabSupplierTable extends Migration {

	public function up()
	{
		Schema::create('tabSupplier', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('avatar')->nullable();
			$table->string('status', 10)->default('Active');
			$table->string('tagline')->nullable();
			$table->string('verified', 10)->default('No');
			$table->string('email_id');
			$table->string('contact_no');
			$table->text('address')->nullable();
			$table->integer('city_id')->unsigned();
			$table->string('website')->nullable();
			$table->string('country');
			$table->string('type');
			$table->string('no_of_employees')->nullable();
			$table->string('legal_status')->nullable();
			$table->date('member_since');
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tabSupplier');
	}
}