<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tabCity', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('tabCountry')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabCustomerBookmark', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('tabCustomer')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabServiceProvider', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('tabCity')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tabServices', function(Blueprint $table) {
			$table->foreign('service_provider_id')->references('id')->on('tabServiceProvider')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabSupplier', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('tabCity')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tabServiceCity', function(Blueprint $table) {
			$table->foreign('service_provider_id')->references('id')->on('tabServiceProvider')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabServiceCity', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('tabCity')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabServiceBrand', function(Blueprint $table) {
			$table->foreign('service_provider_id')->references('id')->on('tabServiceProvider')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabServiceBrand', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('tabBrand')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabServiceCategory', function(Blueprint $table) {
			$table->foreign('service_provider_id')->references('id')->on('tabServiceProvider')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabServiceCategory', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('tabCategory')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabSupplierCategory', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('tabSupplier')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabSupplierCategory', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('tabCategory')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabSupplierCity', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('tabSupplier')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabSupplierCity', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('tabCity')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('tabBrand')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('tabCategory')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('tabEvent', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('tabCategory')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabEvent', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('tabCity')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabSupplierApproval', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('tabSupplier')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabSupplierApproval', function(Blueprint $table) {
			$table->foreign('approval_id')->references('id')->on('tabApproval')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabSupplierDetail', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('tabSupplier')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProductDetail', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('tabProduct')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tabProductApproval', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('tabProduct')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tabProductApproval', function(Blueprint $table) {
			$table->foreign('approval_id')->references('id')->on('tabApproval')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tabProductThumbnails', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('tabProduct')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tabProductSupplier', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('tabProduct')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tabProductSupplier', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('tabSupplier')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tabCity', function(Blueprint $table) {
			$table->dropForeign('tabCity_country_id_foreign');
		});
		Schema::table('tabCustomerBookmark', function(Blueprint $table) {
			$table->dropForeign('tabCustomerBookmark_customer_id_foreign');
		});
		Schema::table('tabServiceProvider', function(Blueprint $table) {
			$table->dropForeign('tabServiceProvider_city_id_foreign');
		});
		Schema::table('tabServices', function(Blueprint $table) {
			$table->dropForeign('tabServices_service_provider_id_foreign');
		});
		Schema::table('tabSupplier', function(Blueprint $table) {
			$table->dropForeign('tabSupplier_city_id_foreign');
		});
		Schema::table('tabServiceCity', function(Blueprint $table) {
			$table->dropForeign('tabServiceCity_service_provider_id_foreign');
		});
		Schema::table('tabServiceCity', function(Blueprint $table) {
			$table->dropForeign('tabServiceCity_city_id_foreign');
		});
		Schema::table('tabServiceBrand', function(Blueprint $table) {
			$table->dropForeign('tabServiceBrand_service_provider_id_foreign');
		});
		Schema::table('tabServiceBrand', function(Blueprint $table) {
			$table->dropForeign('tabServiceBrand_brand_id_foreign');
		});
		Schema::table('tabServiceCategory', function(Blueprint $table) {
			$table->dropForeign('tabServiceCategory_service_provider_id_foreign');
		});
		Schema::table('tabServiceCategory', function(Blueprint $table) {
			$table->dropForeign('tabServiceCategory_category_id_foreign');
		});
		Schema::table('tabSupplierCategory', function(Blueprint $table) {
			$table->dropForeign('tabSupplierCategory_supplier_id_foreign');
		});
		Schema::table('tabSupplierCategory', function(Blueprint $table) {
			$table->dropForeign('tabSupplierCategory_category_id_foreign');
		});
		Schema::table('tabSupplierCity', function(Blueprint $table) {
			$table->dropForeign('tabSupplierCity_supplier_id_foreign');
		});
		Schema::table('tabSupplierCity', function(Blueprint $table) {
			$table->dropForeign('tabSupplierCity_city_id_foreign');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->dropForeign('tabProduct_brand_id_foreign');
		});
		Schema::table('tabProduct', function(Blueprint $table) {
			$table->dropForeign('tabProduct_category_id_foreign');
		});
		Schema::table('tabEvent', function(Blueprint $table) {
			$table->dropForeign('tabEvent_category_id_foreign');
		});
		Schema::table('tabEvent', function(Blueprint $table) {
			$table->dropForeign('tabEvent_city_id_foreign');
		});
		Schema::table('tabSupplierApproval', function(Blueprint $table) {
			$table->dropForeign('tabSupplierApproval_supplier_id_foreign');
		});
		Schema::table('tabSupplierApproval', function(Blueprint $table) {
			$table->dropForeign('tabSupplierApproval_approval_id_foreign');
		});
		Schema::table('tabSupplierDetail', function(Blueprint $table) {
			$table->dropForeign('tabSupplierDetail_supplier_id_foreign');
		});
		Schema::table('tabProductDetail', function(Blueprint $table) {
			$table->dropForeign('tabProductDetail_product_id_foreign');
		});
		Schema::table('tabProductApproval', function(Blueprint $table) {
			$table->dropForeign('tabProductApproval_product_id_foreign');
		});
		Schema::table('tabProductApproval', function(Blueprint $table) {
			$table->dropForeign('tabProductApproval_approval_id_foreign');
		});
		Schema::table('tabProductThumbnails', function(Blueprint $table) {
			$table->dropForeign('tabProductThumbnails_product_id_foreign');
		});
		Schema::table('tabProductSupplier', function(Blueprint $table) {
			$table->dropForeign('tabProductSupplier_product_id_foreign');
		});
		Schema::table('tabProductSupplier', function(Blueprint $table) {
			$table->dropForeign('tabProductSupplier_supplier_id_foreign');
		});
	}
}