<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('iso_code')->nullable();
			$table->string('phone_code')->nullable();
			$table->string('nationality')->nullable();
			$table->boolean('default');
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}