<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEbookDetailsTable extends Migration {

	public function up()
	{
		Schema::create('ebook_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('book_id')->unsigned();
			$table->enum('format', array(''));
			$table->enum('pricing_model', array(''free'', ''paid'', ''subscription''));
			$table->integer('price');
		});
	}

	public function down()
	{
		Schema::drop('ebook_details');
	}
}