<?php

namespace models;

use Illuminate\Database\Eloquent\Model;

class Store extends Model 
{

    protected $table = 'stores';
    public $timestamps = true;
    protected $fillable = array('name', 'phone', 'address', 'image', 'views', 'active');

    public function User()
    {
        return $this->belongsTo('models\User', 'user_id');
    }

    public function MeetTypes()
    {
        return $this->hasMany('models\MeetType', 'store_id');
    }

}