<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('firstname');
			$table->string('lastname');
			$table->integer('branch_id')->unsigned();
			$table->integer('role_id')->unsigned();
			$table->boolean('enabled');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}