<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->enum('kit', array('gold', 'silver', 'bronze'));
			$table->string('phone');
			$table->text('address');
			$table->string('city');
			$table->string('postcode');
			$table->string('website');
			$table->integer('group_id')->unsigned();
			$table->timestamps();
			$table->datetime('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}