<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Model extends Model 
{

    protected $table = 'models';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function guarantees()
    {
        return $this->hasMany('Guarantee');
    }

    public function make()
    {
        return $this->belongsTo('Make');
    }

}