<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function type()
	{
		return $this->belongsTo('ProductType');
	}

	public function guarantees()
	{
		return $this->hasMany('Guarantee');
	}

}