<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('guarantees', function(Blueprint $table) {
			$table->foreign('model_id')->references('id')->on('guarantees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('guarantees', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('guarantees', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('models', function(Blueprint $table) {
			$table->foreign('make_id')->references('id')->on('makes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('product_types_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('guarantees', function(Blueprint $table) {
			$table->dropForeign('guarantees_model_id_foreign');
		});
		Schema::table('guarantees', function(Blueprint $table) {
			$table->dropForeign('guarantees_product_id_foreign');
		});
		Schema::table('guarantees', function(Blueprint $table) {
			$table->dropForeign('guarantees_user_id_foreign');
		});
		Schema::table('models', function(Blueprint $table) {
			$table->dropForeign('models_make_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_product_types_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_branch_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_group_id_foreign');
		});
	}
}