<?php

namespace App\Model;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'password', 'image', 'district_id', 'pin_code', 'api_token');

	public function district()
	{
		return $this->belongsTo('App\Model\District');
	}

	public function orders()
	{
		return $this->belongsToMany('App\Model\Order');
	}

	public function token()
	{
		return $this->morphedByMany('App\Model\Token');
	}

	public function comments()
	{
		return $this->hasMany('App\Model\Comment');
	}

	public function notification()
	{
		return $this->morphedByMany('App\Model\Notification');
	}

	public function contact()
	{
		return $this->morphedByMany('App\Model\Contact');
	}

}