<?php

namespace App\Model;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('client_id', 'restaurant_id', 'cost', 'total', 'commission', 'status');

	public function clients()
	{
		return $this->belongsToMany('App\Model\Client');
	}

	public function restaurant()
	{
		return $this->belongsTo('App\Model\Restaurant');
	}

	public function meals()
	{
		return $this->belongsToMany('App\Model\Meal');
	}

}