<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('phone', 255);
			$table->string('minimum_charge', 255);
			$table->integer('district_id');
			$table->double('delivery_cost', 255);
			$table->string('whatsapp_link', 255);
			$table->string('image', 255);
			$table->string('password', 255);
			$table->boolean('activated');
			$table->boolean('status');
			$table->string('api_token', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}