<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServerDetail extends Model 
{

    protected $table = 'server_detail';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function project()
    {
        return $this->belongsToMany('Models\Project', 'project_server_detail', 'project_id', 'server_detail_id');
    }

}