<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ServerDetail extends Eloquent {

	protected $table = 'server_detail';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function project()
	{
		return $this->belongsToMany('Models\Project', 'project_server_detail', 'project_id', 'server_detail_id');
	}

}