<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('news_id');
			$table->string('news_title', 255);
			$table->tinyInteger('news_status');
			$table->datetime('news_date_time');
			$table->text('news_summary');
			$table->string('news_reporter')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}