<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerProductsTable extends Migration {

	public function up()
	{
		Schema::create('mer_products', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('name', 255)->nullable();
			$table->string('keywords', 255)->nullable();
			$table->string('short_description', 255)->nullable();
			$table->text('description')->nullable();
			$table->tinyInteger('is_active')->default('0');
			$table->string('code', 100);
			$table->double('unit_price', 10,4)->nullable();
			$table->double('unit_cost', 10,4)->nullable();
			$table->double('weight', 10,4)->nullable();
			$table->text('header')->nullable();
			$table->text('footer')->nullable();
			$table->tinyInteger('is_taxed')->default('0');
			$table->string('small_image', 255)->nullable();
			$table->string('medium_image', 255)->nullable();
			$table->string('larage_image', 255)->nullable();
			$table->string('extra1', 255)->nullable();
			$table->string('extra2', 255)->nullable();
			$table->string('extra3', 255)->nullable();
			$table->string('extra4', 255)->nullable();
			$table->string('extra5')->nullable();
			$table->bigInteger('category_id')->unsigned()->nullable();
			$table->integer('product_order')->default('0');
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_products');
	}
}