<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerBasicTaxRateTable extends Migration {

	public function up()
	{
		Schema::create('mer_basic_tax_rate', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->bigInteger('state_id')->unsigned()->nullable();
			$table->tinyInteger('is_active')->nullable()->default('0');
			$table->string('city', 255)->nullable();
			$table->double('rate', 10,4)->nullable();
			$table->string('scope', 255)->nullable();
			$table->string('postal_code', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_basic_tax_rate');
	}
}