<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerSettingTable extends Migration {

	public function up()
	{
		Schema::create('mer_setting', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->softDeletes();
			$table->string('code', 100)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('description', 255)->nullable();
			$table->string('type', 100)->nullable();
			$table->string('value_type', 16)->nullable();
			$table->integer('integer_value')->nullable();
			$table->string('small_value', 64)->nullable();
			$table->string('medium_value', 255)->nullable();
			$table->text('text_value')->nullable();
			$table->string('scope', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('mer_setting');
	}
}