<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerStateTable extends Migration {

	public function up()
	{
		Schema::create('mer_state', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->string('code', 100)->nullable();
			$table->string('name', 255)->nullable();
			$table->tinyInteger('is_active')->nullable()->default('0');
			$table->tinyInteger('state_order')->default('0');
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_state');
	}
}