<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerCountryTable extends Migration {

	public function up()
	{
		Schema::create('mer_country', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code', 100)->nullable();
			$table->string('name', 255)->nullable();
			$table->tinyInteger('is_active')->default('0');
			$table->tinyInteger('allow_order_state')->default('0');
			$table->tinyInteger('country_order')->default('0');
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_country');
	}
}