<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerSkuTable extends Migration {

	public function up()
	{
		Schema::create('mer_sku', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('attribute_id1')->unsigned()->nullable();
			$table->bigInteger('option_id1')->unsigned()->nullable();
			$table->bigInteger('attribute_id2')->unsigned()->nullable();
			$table->bigInteger('option_id2')->unsigned()->nullable();
			$table->bigInteger('attribute_id3')->unsigned()->nullable();
			$table->bigInteger('option_id3')->unsigned()->nullable();
			$table->bigInteger('attribute_id4')->unsigned()->nullable();
			$table->bigInteger('option_id4')->unsigned()->nullable();
			$table->bigInteger('attribute_id5')->unsigned()->nullable();
			$table->bigInteger('option_id5')->unsigned()->nullable();
			$table->string('number', 128)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('message', 255)->nullable();
			$table->string('extra1', 255)->nullable();
			$table->string('extra2', 255)->nullable();
			$table->string('extra3', 255)->nullable();
			$table->string('track_inventory', 255)->nullable();
			$table->integer('inventory_level')->nullable();
			$table->string('note', 255)->nullable();
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_sku');
	}
}