<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('livres', function(Blueprint $table) {
			$table->foreign('editeur_id')->references('id')->on('editeurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('auteur_livre', function(Blueprint $table) {
			$table->foreign('auteur_id')->references('id')->on('auteurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('auteur_livre', function(Blueprint $table) {
			$table->foreign('livre_id')->references('id')->on('livres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('livres', function(Blueprint $table) {
			$table->dropForeign('livres_editeur_id_foreign');
		});
		Schema::table('auteur_livre', function(Blueprint $table) {
			$table->dropForeign('auteur_livre_auteur_id_foreign');
		});
		Schema::table('auteur_livre', function(Blueprint $table) {
			$table->dropForeign('auteur_livre_livre_id_foreign');
		});
	}
}