<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('location_name', 100);
			$table->string('addr_line_1', 255)->nullable();
			$table->string('addr_line_2', 255)->nullable();
			$table->integer('company_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}