<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitLogsTable extends Migration {

	public function up()
	{
		Schema::create('unit_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('unit_id')->unsigned();
			$table->integer('company_id')->unsigned();
			$table->integer('location_id')->unsigned();
			$table->string('action_type', 100);
			$table->text('action_text');
			$table->string('services', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('unit_logs');
	}
}