<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Unit extends Eloquent {

	protected $table = 'units';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('unit_name', 'device_code', 'email', 'no_of_cam');
	protected $visible = array('unit_name', 'email', 'no_of_cam');

	public function company()
	{
		return $this->belongsTo('App\Company');
	}

	public function location()
	{
		return $this->belongsTo('App\Location');
	}

	public function unit_log()
	{
		return $this->hasMany('App\UnitLog');
	}

	public function unit_status_log()
	{
		return $this->hasMany('App\UnitStatusLog', 'id');
	}

	public function unit_error_log()
	{
		return $this->hasMany('App\UnitErrorLog');
	}

	public function unit_schedule()
	{
		return $this->hasMany('App\UnitSchedule');
	}

}