<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeaguesTable extends Migration {

	public function up()
	{
		Schema::create('leagues', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->integer('creator_id')->unsigned();
			$table->string('avatar');
			$table->integer('scoring_type')->unsigned();
			$table->tinyInteger('is_public');
			$table->integer('team_count');
		});
	}

	public function down()
	{
		Schema::drop('leagues');
	}
}