<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGamesTable extends Migration {

	public function up()
	{
		Schema::create('games', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('week')->unsigned();
			$table->string('season');
			$table->string('status');
			$table->datetime('scheduled');
			$table->string('broadcast');
			$table->integer('utc_offset')->unsigned();
			$table->string('time_zone');
		});
	}

	public function down()
	{
		Schema::drop('games');
	}
}