<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('post_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('leagues', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('leagues', function(Blueprint $table) {
			$table->foreign('scoring_type')->references('id')->on('scoring_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('league_schedules', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('league_schedules', function(Blueprint $table) {
			$table->foreign('schedule_id')->references('id')->on('scheduleables')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('premission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('player_news', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stats_player', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matchups', function(Blueprint $table) {
			$table->foreign('scheduleable_id')->references('id')->on('scheduleables')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stats_team', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('original_teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('draftables', function(Blueprint $table) {
			$table->foreign('draftable_type_id')->references('id')->on('draftables')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('friends', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('friends', function(Blueprint $table) {
			$table->foreign('friend_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matchup_teams', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('original_teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matchup_teams', function(Blueprint $table) {
			$table->foreign('matchup_id')->references('id')->on('matchups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('default_rules', function(Blueprint $table) {
			$table->foreign('rule_category')->references('id')->on('default_rule_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('league_rules', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('league_rules', function(Blueprint $table) {
			$table->foreign('defaultrule_id')->references('id')->on('draftables')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invitations', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rosters', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('original_teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rosters', function(Blueprint $table) {
			$table->foreign('draftable_id')->references('id')->on('draftables')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matchup_rosters', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matchup_rosters', function(Blueprint $table) {
			$table->foreign('matchup_id')->references('id')->on('matchups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matchup_rosters', function(Blueprint $table) {
			$table->foreign('draftableTypeId')->references('id')->on('draftable_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matchup_rosters', function(Blueprint $table) {
			$table->foreign('draftable_id')->references('id')->on('draftables')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('injuries', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('game_team', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('game_team', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('original_teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('game_stats', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('game_events', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('game_clock', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('player_points', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trades', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trades_players', function(Blueprint $table) {
			$table->foreign('trade_id')->references('id')->on('trades')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trades_players', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trades_players', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('original_teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trades_players', function(Blueprint $table) {
			$table->foreign('destination_team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trades_teams', function(Blueprint $table) {
			$table->foreign('trade_id')->references('id')->on('trades')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trades_teams', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('update_players', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('update_players', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('update_players', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('league_divisions', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('league_divisions_team', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('league_divisions_team', function(Blueprint $table) {
			$table->foreign('division_id')->references('id')->on('league_divisions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('league_divisions_team', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('original_teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_author_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_category_id_foreign');
		});
		Schema::table('leagues', function(Blueprint $table) {
			$table->dropForeign('leagues_creator_id_foreign');
		});
		Schema::table('leagues', function(Blueprint $table) {
			$table->dropForeign('leagues_scoring_type_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_league_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_creator_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_post_id_foreign');
		});
		Schema::table('league_schedules', function(Blueprint $table) {
			$table->dropForeign('league_schedules_league_id_foreign');
		});
		Schema::table('league_schedules', function(Blueprint $table) {
			$table->dropForeign('league_schedules_schedule_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_premission_id_foreign');
		});
		Schema::table('player_news', function(Blueprint $table) {
			$table->dropForeign('player_news_player_id_foreign');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->dropForeign('players_team_id_foreign');
		});
		Schema::table('stats_player', function(Blueprint $table) {
			$table->dropForeign('stats_player_player_id_foreign');
		});
		Schema::table('matchups', function(Blueprint $table) {
			$table->dropForeign('matchups_scheduleable_id_foreign');
		});
		Schema::table('stats_team', function(Blueprint $table) {
			$table->dropForeign('stats_team_team_id_foreign');
		});
		Schema::table('draftables', function(Blueprint $table) {
			$table->dropForeign('draftables_draftable_type_id_foreign');
		});
		Schema::table('friends', function(Blueprint $table) {
			$table->dropForeign('friends_user_id_foreign');
		});
		Schema::table('friends', function(Blueprint $table) {
			$table->dropForeign('friends_friend_id_foreign');
		});
		Schema::table('matchup_teams', function(Blueprint $table) {
			$table->dropForeign('matchup_teams_team_id_foreign');
		});
		Schema::table('matchup_teams', function(Blueprint $table) {
			$table->dropForeign('matchup_teams_matchup_id_foreign');
		});
		Schema::table('default_rules', function(Blueprint $table) {
			$table->dropForeign('default_rules_rule_category_foreign');
		});
		Schema::table('league_rules', function(Blueprint $table) {
			$table->dropForeign('league_rules_league_id_foreign');
		});
		Schema::table('league_rules', function(Blueprint $table) {
			$table->dropForeign('league_rules_defaultrule_id_foreign');
		});
		Schema::table('invitations', function(Blueprint $table) {
			$table->dropForeign('invitations_league_id_foreign');
		});
		Schema::table('rosters', function(Blueprint $table) {
			$table->dropForeign('rosters_team_id_foreign');
		});
		Schema::table('rosters', function(Blueprint $table) {
			$table->dropForeign('rosters_draftable_id_foreign');
		});
		Schema::table('matchup_rosters', function(Blueprint $table) {
			$table->dropForeign('matchup_rosters_team_id_foreign');
		});
		Schema::table('matchup_rosters', function(Blueprint $table) {
			$table->dropForeign('matchup_rosters_matchup_id_foreign');
		});
		Schema::table('matchup_rosters', function(Blueprint $table) {
			$table->dropForeign('matchup_rosters_draftableTypeId_foreign');
		});
		Schema::table('matchup_rosters', function(Blueprint $table) {
			$table->dropForeign('matchup_rosters_draftable_id_foreign');
		});
		Schema::table('injuries', function(Blueprint $table) {
			$table->dropForeign('injuries_player_id_foreign');
		});
		Schema::table('game_team', function(Blueprint $table) {
			$table->dropForeign('game_team_game_id_foreign');
		});
		Schema::table('game_team', function(Blueprint $table) {
			$table->dropForeign('game_team_team_id_foreign');
		});
		Schema::table('game_stats', function(Blueprint $table) {
			$table->dropForeign('game_stats_player_id_foreign');
		});
		Schema::table('game_events', function(Blueprint $table) {
			$table->dropForeign('game_events_game_id_foreign');
		});
		Schema::table('game_clock', function(Blueprint $table) {
			$table->dropForeign('game_clock_game_id_foreign');
		});
		Schema::table('player_points', function(Blueprint $table) {
			$table->dropForeign('player_points_player_id_foreign');
		});
		Schema::table('trades', function(Blueprint $table) {
			$table->dropForeign('trades_user_id_foreign');
		});
		Schema::table('trades_players', function(Blueprint $table) {
			$table->dropForeign('trades_players_trade_id_foreign');
		});
		Schema::table('trades_players', function(Blueprint $table) {
			$table->dropForeign('trades_players_player_id_foreign');
		});
		Schema::table('trades_players', function(Blueprint $table) {
			$table->dropForeign('trades_players_team_id_foreign');
		});
		Schema::table('trades_players', function(Blueprint $table) {
			$table->dropForeign('trades_players_destination_team_id_foreign');
		});
		Schema::table('trades_teams', function(Blueprint $table) {
			$table->dropForeign('trades_teams_trade_id_foreign');
		});
		Schema::table('trades_teams', function(Blueprint $table) {
			$table->dropForeign('trades_teams_team_id_foreign');
		});
		Schema::table('update_players', function(Blueprint $table) {
			$table->dropForeign('update_players_league_id_foreign');
		});
		Schema::table('update_players', function(Blueprint $table) {
			$table->dropForeign('update_players_team_id_foreign');
		});
		Schema::table('update_players', function(Blueprint $table) {
			$table->dropForeign('update_players_player_id_foreign');
		});
		Schema::table('league_divisions', function(Blueprint $table) {
			$table->dropForeign('league_divisions_league_id_foreign');
		});
		Schema::table('league_divisions_team', function(Blueprint $table) {
			$table->dropForeign('league_divisions_team_league_id_foreign');
		});
		Schema::table('league_divisions_team', function(Blueprint $table) {
			$table->dropForeign('league_divisions_team_division_id_foreign');
		});
		Schema::table('league_divisions_team', function(Blueprint $table) {
			$table->dropForeign('league_divisions_team_team_id_foreign');
		});
	}
}