<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatchupTeamsTable extends Migration {

	public function up()
	{
		Schema::create('matchup_teams', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('team_id')->unsigned();
			$table->integer('matchup_id')->unsigned();
			$table->boolean('win')->default(0);
			$table->boolean('loss')->default(0);
			$table->boolean('tie')->default(0);
			$table->integer('rank')->default('0');
			$table->float('points');
		});
	}

	public function down()
	{
		Schema::drop('matchup_teams');
	}
}