<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('author_id')->unsigned();
			$table->string('title');
			$table->text('body');
			$table->string('image')->nullable();
			$table->integer('category_id')->unsigned();
			$table->string('slug')->unique();
			$table->text('excerpt')->nullable();
			$table->string('caption');
			$table->enum('status', array('PUBLISHED', 'DRAFT', 'PENDING'));
			$table->tinyInteger('featured');
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}