<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->string('name');
			$table->string('email');
			$table->string('password');
			$table->string('avatar')->nullable();
			$table->string('remember_token');
			$table->integer('role_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->string('postal_code');
			$table->string('street');
			$table->string('stripe_id');
			$table->string('card_brand');
			$table->string('card_last_four');
			$table->datetime('date_of_birth');
			$table->decimal('balance');
			$table->string('username');
			$table->string('city');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}