<?php

namespace Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function user_leagues()
	{
		return $this->hasMany('Models\League', 'creator_id', 'id');
	}

	public function teams()
	{
		return $this->hasMany('Models\Team', 'user_id', 'id');
	}

	public function role()
	{
		return $this->belongsTo('Models\Role');
	}

}