<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Invitation extends Model 
{

    protected $table = 'invitations';
    public $timestamps = true;

    public function user()
    {
        return $this->hasOne('Models\User', 'email', 'emailAddress');
    }

    public function rules()
    {
        return $this->belongsTo('Models\LeagueRule', 'league_id', 'id');
    }

    public function league()
    {
        return $this->belongsTo('Models\League', 'league_id', 'id');
    }

}