<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCovenantsTable extends Migration {

	public function up()
	{
		Schema::create('covenants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('covenant_number');
			$table->integer('covenant_name_id');
			$table->integer('office_id');
			$table->integer('employee_id');
			$table->enum('mobility', array('fulltime', 'parttime', 'daily', 'weekly'));
			$table->boolean('in_stock')->default(0);
			$table->string('covenant_stock_number');
		});
	}

	public function down()
	{
		Schema::drop('covenants');
	}
}