<?php

namespace App\Models;

class Employee extends Eloquent {

	protected $table = 'employees';
	public $timestamps = true;
	protected $fillable = array('name', 'job_id', 'office_id');

	public function job()
	{
		return $this->belongsTo('App\Models\Job');
	}

	public function office()
	{
		return $this->belongsTo('App\Models\Office');
	}

	public function covenants()
	{
		return $this->hasMany('App\Models\Covenant');
	}

}