<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('body_shape_id')->unsigned();
			$table->integer('size_id')->unsigned();
			$table->bigInteger('order_number');
			$table->date('order_date');
			$table->string('refused_reason');
			$table->integer('gender');
			$table->string('occasion', 30);
			$table->datetime('occasion_date');
			$table->integer('Budget');
			$table->decimal('price');
			$table->decimal('vat');
			$table->integer('vat_rate');
			$table->decimal('total');
			$table->integer('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}