<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Produit extends Model 
{

    protected $table = 'produits';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function categorie()
    {
        return $this->hasOne('Categorie');
    }

    public function detailEntreeProduit()
    {
        return $this->hasMany('DetailEntreeProduit');
    }

    public function detailsVenteProduit()
    {
        return $this->hasMany('DetailVenteProduit');
    }

}