<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DetailEntreeProduit extends Eloquent {

	protected $table = 'details_entree_produit';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function entreeProduit()
	{
		return $this->hasOne('EntreeProduit');
	}

	public function fournisseur()
	{
		return $this->hasOne('Fournisseur');
	}

	public function produit()
	{
		return $this->hasOne('Produit');
	}

}