<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProduitsTable extends Migration {

	public function up()
	{
		Schema::create('produits', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('reference');
			$table->integer('categorie_id')->unsigned();
			$table->decimal('qte_stock');
			$table->decimal('qte_seuil');
			$table->string('image')->default('produit.default');
			$table->string('marque');
		});
	}

	public function down()
	{
		Schema::drop('produits');
	}
}