<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username')->unique();
			$table->string('password');
			$table->string('code')->unique();
			$table->string('name');
			$table->integer('job_id')->unsigned()->nullable();
			$table->string('job_title')->nullable();
			$table->integer('team_id')->unsigned()->nullable();
			$table->integer('municipal_id')->unsigned()->nullable();
			$table->integer('district_id')->unsigned()->nullable();
			$table->tinyInteger('active')->unsigned()->default('0');
			$table->string('mode')->default('Light');
			$table->string('menu')->default('Show');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}